#RS Games Client
#Main Python Mod
#Copyright RSGames/ZanoSoft 2010-2012

# from platform_utils import blackhole # Thread on-exit errors be gone!
from platform_utils import paths
from logger_setup import setup_logging
import os
os.chdir(paths.app_path())
import platform
import logging
import application
import global_vars

import gui
import output
import sound
import update


def main():
    try:
        paths.prepare_app_data_path('ZGP')
        global_vars.data_dir=paths.app_data_path('ZGP')
        setup_logging(error_log=os.path.join(paths.app_data_path("ZGP"), "errors.log"))
        logging.info("Program run")
        import sys
        logging.info(str(sys.path[0]))
        print(("Welcome to the RS Games Client Version " + str(application.version)))
        output.setup()
        sound.setup()
        logging.info("Working directory: " + str(os.getcwd()))
        output.output("Welcome to the " + global_vars.cname + " Version " + str(application.version))
        if platform.system() == 'Windows':
            update.check_for_update() #checks for update at hardcoded path
        gui.start()
    except:
        logging.exception("initialization error.")
      
if __name__ == '__main__':
    main()
